/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.smallships.world.entity.ship.abilities;

import com.mojang.datafixers.util.Pair;
import com.talhanation.smallships.client.model.sail.SailModel;
import com.talhanation.smallships.world.entity.ship.Ship;
import com.talhanation.smallships.world.entity.ship.abilities.Ability;
import com.talhanation.smallships.world.sound.ModSoundTypes;
import java.util.function.BiConsumer;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1769;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_3414;
import net.minecraft.class_3417;

public interface Sailable
extends Ability {
    default public void tickSailShip() {
        if (this.self().method_5685().size() > 0 && this.self().method_5642() instanceof class_1657) {
            float speed = this.self().getData(Ship.SPEED).floatValue();
            byte currentState = this.self().getData(Ship.SAIL_STATE);
            if (currentState == 0 && speed > 0.0f) {
                this.self().setData(Ship.SPEED, Float.valueOf(Math.max(0.0f, speed - this.self().getAttributes().acceleration * 1.1f)));
            } else if (currentState > 0 && this.self().field_6012 % 20 == 0) {
                float maxSpeedRatio = this.self().getAttributes().maxSpeed / 4.0f;
                if (speed < maxSpeedRatio) {
                    this.self().setData(Ship.SAIL_STATE, (byte)1);
                } else if (speed < maxSpeedRatio * 2.0f) {
                    this.self().setData(Ship.SAIL_STATE, (byte)2);
                } else if (speed < maxSpeedRatio * 3.0f) {
                    this.self().setData(Ship.SAIL_STATE, (byte)3);
                } else {
                    this.self().setData(Ship.SAIL_STATE, (byte)4);
                }
                byte newState = this.self().getData(Ship.SAIL_STATE);
                if (currentState != newState) {
                    this.playSailSound(newState);
                }
            }
        }
    }

    default public void defineSailShipSynchedData() {
        this.self().method_5841().method_12784(Ship.SAIL_STATE, (Object)0);
        this.self().method_5841().method_12784(Ship.SAIL_COLOR, (Object)SailModel.Color.WHITE.toString());
    }

    default public void readSailShipSaveData(class_2487 tag) {
        class_2487 compoundTag = tag.method_10562("Sail");
        this.self().setData(Ship.SAIL_STATE, compoundTag.method_10571("State"));
        this.self().setData(Ship.SAIL_COLOR, compoundTag.method_10558("Color"));
    }

    default public void addSailShipSaveData(class_2487 tag) {
        class_2487 compoundTag = new class_2487();
        compoundTag.method_10569("State", (int)this.self().getData(Ship.SAIL_STATE).byteValue());
        compoundTag.method_10582("Color", this.self().getData(Ship.SAIL_COLOR));
        tag.method_10566("Sail", (class_2520)compoundTag);
    }

    default public boolean interactSail(class_1657 player, class_1268 interactionHand) {
        class_1799 item = player.method_5998(interactionHand);
        class_1792 class_17922 = item.method_7909();
        if (class_17922 instanceof class_1769) {
            class_1769 dyeItem = (class_1769)class_17922;
            String color = dyeItem.method_7802().method_7792();
            if (color.equals(this.self().getData(Ship.SAIL_COLOR))) {
                return false;
            }
            this.self().setData(Ship.SAIL_COLOR, color);
            if (!player.method_7337()) {
                item.method_7934(1);
            }
            this.self().method_37908().method_43128(null, this.self().method_23317(), this.self().method_23318() + 4.0, this.self().method_23321(), class_3417.field_14628, this.self().method_5634(), 15.0f, 1.5f);
            return true;
        }
        return false;
    }

    default public void toggleSail() {
        byte state = this.self().getData(Ship.SAIL_STATE);
        state = state > 0 ? (byte)0 : 1;
        this.self().setData(Ship.SAIL_STATE, state);
        this.playSailSound(state);
    }

    default public void playSailSound(int state) {
        BiConsumer<class_3414, Pair> play = (sound, modifier) -> {
            if (!this.self().method_37908().method_8608()) {
                this.self().method_37908().method_43128(null, this.self().method_23317(), this.self().method_23318() + 4.0, this.self().method_23321(), sound, this.self().method_5634(), ((Float)modifier.getFirst()).floatValue(), ((Float)modifier.getSecond()).floatValue());
            } else {
                this.self().method_37908().method_8486(this.self().method_23317(), this.self().method_23318() + 4.0, this.self().method_23321(), sound, this.self().method_5634(), ((Float)modifier.getFirst()).floatValue(), ((Float)modifier.getSecond()).floatValue(), false);
            }
        };
        if (state != 0) {
            play.accept(ModSoundTypes.SAIL_MOVE, Pair.of((Object)Float.valueOf(15.0f), (Object)Float.valueOf(Math.max(0.5f, 1.4f - (float)state / 5.0f))));
        } else {
            play.accept(ModSoundTypes.SAIL_PULL, Pair.of((Object)Float.valueOf(10.0f), (Object)Float.valueOf(1.0f)));
        }
    }
}

